; Programm TestIU
; written with PB_4.00
; Version 2.02
; Autor: Jens Haipeter

; ===========================================================================
; Bitte lesen!
; ===========================================================================

; Der hier verwendete Key-Ordner in der Registry ist <Software\JensSoft\TEST>
; Alle Eintrge erfolgen in den Key: #HKEY_CURRENT_USER
; Der Schlsselordner liegt in der Konstante #RegKeyName
; Die Angabe der Eintrge kann erweitert werden wenn man mag, ansonsten
; sind sie vorbelegt und brauchen nicht gendert zu werden (Setup.pbi)

; Das Setup als solches funktiert nur als EXE! Sonst luft das Programm
; als solches einfach durch, hier nur der Requester ganz unten am Ende.

; Eintrge und zum Teil auch berprfungen von Registryeintrgen erfolgen
; nur als EXE, nicht jedoch wenn das Programm aus dem Compiler luft.

; Die meisten Sachen werden beim Start der Setup_xxx.exe mit dem
; Include_Setup.pbi erledigt. Einige Abfragen erfolgen jedoch bei
; jedem Start. Manches ist nur Andeutungsweise vorhanden. Das Programm
; wird nach dem Start der setup_xxx.exe und Bejahen der Installation
; in den ausgewhlten Ordner kopiert und dabei in xxx.exe umbenannt,
; ist also ein und das selbe Programm. (Die Konstanten #SetupExeName
; und #RunExeName)

; Wenn man bentigt, kann man unten die beiden Eintrge frei machen
; und in <Eigene Dateien> Datenordner anlegen. Achtung, diese werden
; mit UnInstall nicht gelscht!
; Die flexible Gestaltung der Pfade habe ich gemacht, damit man den
; Ordner auch verschieben kann (vom Programm aus, nicht mit der Hand),
; dies habe ich jedoch hier nicht mit verarbeitet, das ist sozusagen
; einer der Punkte die nur im Ansatz erkennbar sind. Achtung, wenn man
; verschiebt, so sollte man es so absichern, das es nicht in den Programm-
; ordner verschoben wird, sonst kann es Probleme geben.
; Hier nur soviel: Im Falle der Verschiebung den Eintrag in der Registry
; mit ndern, aber nur bis zum neuen Namen fr _DataPath, nicht die
; eigentlichen Datenordner mit angeben. Wenn alles richtig gemacht ist,
; wird dann bei UnInstall der Datenordner wieder nach <Eigene Dateien>
; zurckverlegt und steht sofort wenn man ihn haben mu weil man das
; Programm doch wieder verwenden will zur Verfgung.

; Die Instanzenprfung erfolgt auf den Namen der Konstante #InstanceName
; und zwar mit dem Fensternamen des Dummyfensters. In der Procedure
; stehen die berprfungen ziemlich unten, dort wird der bergabestring
; entsprechend belegt, falls gefunden. Es kann sein, das wenn im PB-Editor
; ein File offen ist, was genau den String in der Fensterzeile enthlt,
; auch eine Instanzenmeldung erscheint, dann einfach den Quellcode auf
; ein anderes Include wechseln.
; Wenn man mehrere will, einfach den Procedureaufruf entfernen.
; Ich will immer nach Mglichkeit nur eine. Die Instanzenabfrage basiert
; auf einem Code von GPI, das steht aber auch noch im Include_Process.pbi.

; Das Setup kann auch wiederholt werden, es wird geprft. Wenn eine andere
; Version oder ein gendertes Versionsdatum in den Konstanten #Version oder
; #Actual steht wird es nach Abfrage ausgefhrt, ist es gleich, kann man
; berschreiben whlen. Ist es eine Neuinstallation ist ja eh alles klar.

; Die Konstanten #AutorName, #CopyRight, #AutorWebSite werden sofort
; auch im Startfenster bei der Installation sichtbar, man kann sich
; so ggf. die nderung des Textes in der Setup.pbi schenken.

; Ich meine alles richtig hingefummelt zu haben, auf Versehen, na ja
; bitte nicht gleich erschlagen. :D

; Ich hoffe, es ist brauchbar, bei ReiseKosten und Control_USB_Port
; jedenfalls funktioniert es ganz ordentlich.

; Jens

; ===========================================================================

; Das Programm bentigt:
; Die JHRegistry_400 Lib, ab Version 2.08

; ===========================================================================

; Da der UnInstaller ein eigenstndiges Programm ist, mssen dort die
; notwendigen nderungen separat vorgenommen werden. Die Namen der dort
; verwendeten Konstanten sind identisch. Der UnInstall.pbi befindet sich
; im Ordner <Integrated> des Quellcodeverzeichnisses. Die dort erstellte
; EXE mu den Namen der Konstante #UnInstExeName besitzen.
; Das Hauptprogramm kompilieren unter dem Namen der Konstante #SetupExeName

; ===========================================================================

; Konstanten, die von den Registryeintrgen verwendet werden und fr die
; berprfung der Instanz herangezogen werden
  #AutorName    ="Jens Haipeter"                   ; Name des Autors, wird auch im Setup-Fenster verwendet
  #CopyRight    ="by Jens Haipeter (c) - 2005/2006"; Copyright, findet im Text des Setup Verwendung und im Fenstertext des Hauptfensters
  #Version      ="TestIU_V2.0.001"                 ; Name der Programmversion, Zahl nach V immer in dieser Art angeben, wird von Setup.pbi verwendet
  #Create       ="28.12.2005"                      ; Datum der ersten Erstellung
  #Actual       ="23.10.2006"                      ; Aktuelles Versionsdatum
  #SetupExeName ="setup_test_iu.exe"               ; Name des Programms nach der Kompilierung
  #RunExeName   ="test_iu.exe"                     ; das Gleiche Programm an seinem Ort als installierte Version
  #UnInstExeName="IUUnInst.exe"                    ; Name der UnInstaller.exe, befindet sich im Ordner Integrated
  #UnInstParam  ="IUUnInstall"                     ; bergabeparameter fr den Unistaller um ungewolltes lschen zu vermeiden
  #InstanceName ="Test_IU"                         ; gleichzeitig vorderer Teil des Programmfensternamens, eigener Namesanteil
                                                   ; am Programmpfad, Name des Startmenueintrages und Teil des Datenpfades
  #DeskLinkName ="TestIU"                          ; Name des Links auf dem Desktop, .lnk wird hinzugefgt wo ntig
  #RegKeyName   ="Software\JensSoft\TEST"          ; alle Eintrge erfolgen in den Key #HKEY_CURRENT_USER und dort in Software
  #HelpFileNameC="IUAnleitung.chm"                 ; Name eines eventuellen Hilfefile als chm
  #HelpFileNameP="IUAnleitung.pdf"                 ; Name eines eventuellen Hilfefile
  #AutorWebSite ="www.jens-haipeter.de"            ; findet im Text des Setup Verwendung
  
Enumeration
  ; Fenster
  #Win_Hide; Proformafenster, dient nur zur Instanzenabfrage
  #Window_0; Hauptfenster und Startabfrage
  #Window_1; Setupfenster
  ; Gadget
  ; Fonts
  #Main_Font
  ; Image
  #Image_0
EndEnumeration

; Schriftfaktor festlegen, falls jemand die Desktopeinstellungen verndert hat
  Declare.w Desktop_DPI(); befindet sich im Include_Requester.pbi
  Global _FtFkt.f
  Global _FtNam.s
  _FtNam="MS Sans Serif"
  _FtFkt=1
  If Desktop_DPI()>0
    _FtFkt=96/Desktop_DPI()
    If Desktop_DPI()>96
      _FtNam="Arial"
    EndIf
  EndIf

; GadgetFontText fr alle, ist abhngig von den Systemeinstellungen (Schriftgrad Desktop)
  If LoadFont(#Main_Font ,_FtNam, 8*_FtFkt): Else: End: EndIf
  SetGadgetFont(#PB_Default,FontID(#Main_Font))

; Globale Variable und Felder
  Global _WinName.s
  Global _infotit.s
  Global _stoptit.s
  Global _infomsg.s
  Global _TempPath.s
  Global _ExeName.s
  Global _ExePath.s
  Global _PersPath.s
  Global _StartMenu.s
  Global _DataPath.s
  Global _ProgPath.s
  Global _SavePath.s
  Global _ErrTxt.s
  Global _MessageID.l
  Global _Desk_X.l
  Global _Desk_Y.l

; Globale belegen
  _WinName  =#InstanceName+" "+#CopyRight
  _infotit  ="INFORMATION"
  _stoptit  ="ABBRUCHINFORMATION"
  _infomsg  ="no message"
  _TempPath =GetTemporaryDirectory()
; Struktur und Listen fr Instanzenrequester
  Structure info 
    handle.l 
    process.l 
    class$ 
    name$ 
  EndStructure 
  Global NewList info.info() 
  Global NewList AllHandle()

; Exe-Laufwerk feststellen
  _ExePath = Space(255) 
  GetModuleFileName_(0, @_ExePath, 255) 
  _ExeName  = GetFilePart(_ExePath)
  _ExePath  = GetPathPart(_ExePath) 
  _PersPath = JHRegGetPersonalPath()
  _DataPath = _PersPath
  _ProgPath = JHRegGetProgramsPath()
  _SavePath = _DataPath+#InstanceName+"\Daten\"
  _StartMenu= JHRegGetStartMenuProgramsPath()+#InstanceName+"\" 

; Bildschirmgre feststellen, Fensterbreite Hauptfenster festlegen
  ExamineDesktops()
  _Desk_X=DesktopWidth (0)
  _Desk_Y=DesktopHeight(0)

; Proceduren vordeklarieren, falls erforderlich
;  Declare Setup()

; Proceduren
; Include Proceduren (Requester usw.) Standardinclude, damit entfllt die
; Declaration der enthaltenen Proceduren.

; PB Include, binr Include stehen am Quellcodeende
  IncludeFile("include\include_requester.pbi"); abgespeckte Requester.pbi von oben
  IncludeFile("include\include_process.pbi"  ); Prozeabfrage
  IncludeFile("include\include_setup.pbi"    ); Setup

; die ganze IF kann wegbleiben wenn man mehrere Instanzen will, auch
; kann dann das Include_Process.pbi entfallen und die Zuweisung der Strukturen
  If OpenWindow(#Window_0,0,0,10,10,"",#PB_Window_Invisible) 
    RefreshList(); hier erfolgt die Instanzenabfrage
    If FindString(_infomsg,#InstanceName,1)
      _infomsg=#InstanceName+".exe luft breits. Der Start weiterer"+Chr(13)
      _infomsg+"Instanzen ist nicht vorgesehen. Sollten Sie eben"+Chr(13)
      _infomsg+"versucht haben, "+#InstanceName+".exe zu deinstallieren, so"+Chr(13)
      _infomsg+"ist dies nur mglich, wenn das Programm nicht luft."+Chr(13)
      _infomsg+"Gleiches gilt fr ein eventuelles UpDate. Ein Setup"+Chr(13)
      _infomsg+"auf eine neuere Version wird immer in den aktuellen"+Chr(13)
      _infomsg+"Pfad des Programms ausgefhrt."
      MessageBoxS()
      End
    EndIf
    _infomsg="no message"
    CloseWindow(#Window_0)
  EndIf

; Dummyfenster ffnen, bleibt offen bis Programmende (fr Prozeabfrage)
; kann wegbleiben, wenn man mehrere Instanzen zulassen will
  If OpenWindow(#Win_Hide,0,0,10,10,#InstanceName+" - this programm is already runing",#PB_Window_Invisible): Else: End: EndIf

; Install immer prfen
  If FindString(UCase(_ExePath),"COMPILERS",1); nicht wenn im PB_Compiler gestartet
  Else
    If UCase(_ExeName)=UCase(#RunExeName)
    ElseIf UCase(_ExeName)=UCase(#SetupExeName)
      rd.s =JHRegGetString(#HKEY_CURRENT_USER,#RegKeyName,"Version")
      rds.s=JHRegGetString(#HKEY_CURRENT_USER,#RegKeyName,"Versdat")
      OpenWindow(#Window_1,0,0,_Desk_X,_Desk_Y,_ExeName,#PB_Window_Invisible|#PB_Window_TitleBar)
      JHRegCreateGradient(RGB(0,0,255),RGB(0,0,0),100,0,#Window_1,#Image_0)
      HideWindow(#Window_1,0)
      If rd=#Version And rds=#Actual
        _infomsg="Setup-Version gleich der auf" +Chr(13)
        _infomsg+"dem PC installierten Version."+Chr(13)+Chr(13)
        _infomsg+"Version"+Chr(9)+": "+#Version +Chr(13)
        _infomsg+"Datum"  +Chr(9)+": "+#Actual  +Chr(13)+Chr(13)
        _infomsg+"berschreiben?"+Chr(13)
        MessageBoxEJN()
        If _MessageID=6
          Setup()
          End
        EndIf
        End
      Else
        Setup()
        End
      EndIf
      CloseWindow(#Window_1)
    Else
      End
    EndIf
  EndIf

;Kopiere den UnInstaller nach Windows\Temp
  i=0
  If DeleteFile(_TempPath+#UnInstExeName)
    Delay(50)
  EndIf
  If OpenFile(1,_TempPath+#UnInstExeName)
    Repeat
      WriteByte(1,PeekB(?UnInst+i))
      i+1
    Until i>=?UnInstEnd-?UnInst
    CloseFile(1)
  EndIf
  
;UnInstall aufrufen, wenn Parameter aktiv
  If ProgramParameter()="UnInstall"
    Delay(1500)
    MID=MessageRequester(#InstanceName+" "+#Version+" entfernen?","Wollen Sie "+#InstanceName+" mit allen Einstellungen entfernen?"+Chr(13)+Chr(13)+"Der Datenordner bleibt erhalten und wird falls verschoben wieder hergestellt in:"+Chr(13)+Chr(13)+_PersPath,4|#MB_ICONQUESTION)
    If MID=6;Lschen ausfhren
      RunProgram(_TempPath+#UnInstExeName,#UnInstParam+" "+_ExePath+" "+"Version: "+#Version,_TempPath);,0)
      End
    Else
      End
    EndIf
  EndIf

; Startmenu/Desktopsymbol, Eintrag neu ertellen bei jedem Start aus anderem Pfad
  If FindString(UCase(_ExePath),"COMPILERS",1); nicht wenn im PB_Compiler gestartet
  Else
    rd.s=JHRegGetString(#HKEY_CURRENT_USER,#RegKeyName,"RunPath")
    _ErrTxt=JHRegLastError()
    If Left(UCase(_ErrTxt),5)="ERROR"
      JHRegSetString(#HKEY_CURRENT_USER,#RegKeyName,"RunPath",_ExePath)
      rd=""
    EndIf
    nomenu=#False
    If ReadFile(1,_StartMenu+#RunExeName)
      CloseFile(1)
    Else
      nomenu=#True  
    EndIf
    If rd<>_ExePath Or nomenu=#True
      ; Startmenu
      If DeleteDirectory(_StartMenu,"*.*",#PB_FileSystem_Recursive): EndIf
      If CreateDirectory(_StartMenu)
        JHRegCreateShortcutSimply(_ExePath+#RunExeName,_StartMenu+#InstanceName,""         ,"",_ExePath +#RunExeName)
        JHRegCreateShortcutSimply(_ExePath+#RunExeName,_StartMenu+"UnInstall"  ,"UnInstall","",_TempPath+#UnInstExeName)
      Else
        _infomsg="Der Link im Startmen konnte"+Chr(13)
        _infomsg+"nicht erstellt werden."
        MessageBoxS(): _MessageID=0
      EndIf
      JHRegSetString(#HKEY_CURRENT_USER,#RegKeyName,"RunPath",_ExePath)
      ; DesktopLink
      If DeleteFile(JHRegGetDesktopPath()+#DeskLinkName+".lnk")
        JHRegSetString(#HKEY_CURRENT_USER,#RegKeyName,"DeskLink","YES")
        Delay(200)
      EndIf
      rd=JHRegGetString(#HKEY_CURRENT_USER,#RegKeyName,"DeskLink")
      lerr.s=JHRegLastError()
      If lerr<>"": rd=lerr: EndIf
      If rd="YES"
        If JHRegCreateShortcutSimply(_ExePath+#RunExeName,JHRegGetDesktopPath()+#DeskLinkName,"","",_ExePath+#RunExeName)
          JHRegSetString(#HKEY_CURRENT_USER,#RegKeyName,"DeskLink","OK")
        EndIf 
      ElseIf rd<>"NO" And rd<>"OK"
        MID=MessageRequester("DESKTOP-LINK erstellen?","Wollen Sie fr "+#InstanceName+" einen Link"+Chr(13)+"auf dem Desktop erstellen?",4|#MB_ICONQUESTION)
        If MID=6
          If JHRegCreateShortcutSimply(_ExePath+#RunExeName,JHRegGetDesktopPath()+#DeskLinkName,"","",_ExePath+#RunExeName)
            JHRegSetString(#HKEY_CURRENT_USER,#RegKeyName,"DeskLink","OK")
          EndIf 
        Else
          JHRegSetString(#HKEY_CURRENT_USER,#RegKeyName,"DeskLink","NO")
        EndIf
      ElseIf rd="OK"
        If ReadFile(1,JHRegGetDesktopPath()+"\"+#DeskLinkName+".lnk")
          CloseFile(1)
        Else  
          If JHRegCreateShortcutSimply(_ExePath+#RunExeName,JHRegGetDesktopPath()+#DeskLinkName,"","",_ExePath+#RunExeName)
            JHRegSetString(#HKEY_CURRENT_USER,#RegKeyName,"DeskLink","OK")
          EndIf 
        EndIf
      EndIf
    EndIf
  EndIf

; Datenpfad feststellen, jedoch nicht im Compiler
  rd=JHRegGetString(#HKEY_CURRENT_USER,#RegKeyName,"DataPath")
  _ErrTxt=JHRegLastError()
  If FindString(UCase(_ExePath),"COMPILERS",1)
  Else
    If Left(UCase(_ErrTxt),5)="ERROR"
      JHRegSetString(#HKEY_CURRENT_USER,#RegKeyName,"DataPath",_DataPath)
    Else
      _DataPath=rd
      _SavePath=_DataPath+#InstanceName+"\Daten\"
    EndIf
  EndIf

; ; Hilfe kopieren
  If FindString(UCase(_ExePath),"COMPILERS",1); nicht wenn im PB_Compiler gestartet
  Else
    ; Kopiere die Hilfe nach Arbeitsverzeichnis wenn nicht vorhanden
    ; bei Update wird die Hilfe gelscht und automatisch durch die aktuelle ersetzt
    i=0
    If FileSize(_ExePath+#HelpFileNameC)<0
      cprw=OpenWindow(#PB_Any,0,0,200,0,"Test_IU - Hilfe kopieren ...",#PB_Window_TitleBar|#PB_Window_ScreenCentered)
      If cprw
        If CreateFile(1,_ExePath+#HelpFileNameC)
          Repeat
            WriteByte(1,PeekB(?CHMHelpFile+i))
            i+1
          Until i>=?CHMHelpFileEnd-?CHMHelpFile
          CloseFile(1)
        EndIf
        Delay(1000); nur eingefgt, damit es sichtbar wird, kann entfernt werden
        CloseWindow(cprw)
      Else
        End
      EndIf
    EndIf
  EndIf


; Hauptprogramm
; Datenordner erffnen wenn nicht vorhanden

; hier knnen Datenordner angelegt werden, Ausgangspunkt ist der festgelegte Ort
; fr den Datenpfad. In der Registry wird der Ordner nur bis _DataPath angezeigt.

;  If CreateDirectory(_DataPath+#InstanceName)         : EndIf
;  If CreateDirectory(_DataPath+#InstanceName+"\Daten"): EndIf

; Einsprung in das Hauptprogramm, hier folgt alles andere

  txt.s="Hier sind einige der verwendeten Namen aufgelistet:"+Chr(13)+Chr(13)
  txt  +"- Pfad des Programms"             +Chr(9)+Chr(9)+_ExePath   +Chr(13)
  txt  +"- Hauptpfad der Daten"            +Chr(9)+Chr(9)+_DataPath  +Chr(13)
  txt  +"- eigener Ordner der Daten"       +Chr(9)+Chr(9)+_SavePath  +Chr(13)
  txt  +"- Name des Programmkey in der Reg"+Chr(9)       +#RegKeyName+Chr(13)
  MessageRequester("UND NUN FOLGT DAS PROGRAMM ...","... aber hier nur als Requester"+Chr(13)+Chr(13)+txt,0)
  End

; binre Include
DataSection
  ChmHelpFile   : IncludeBinary "Integrated\"+#HelpFileNameC
  ChmHelpFileEnd:
  UnInst     : IncludeBinary "Integrated\"+#UnInstExeName
  UnInstEnd  :
EndDataSection
; IDE Options = PureBasic v4.00 (Windows - x86)
; CursorPosition = 76
; FirstLine = 72
; Folding = -
; UseIcon = ICON\program.ico
; Executable = setup_test_iu.exe