; entnommen aus dem Beispiel von PureArea.net ListIcon_FixedColumnHeader.pb
; German forum: http://robsite.de/php/pureboard/viewtopic.php?t=2341&highlight=
; Author: Andreas
; Date: 20. September 2003
; ListIcon FixSizeColumn von A.Miethe
Procedure HeaderCallBack(wnd,uMsg,wParam,lParam) 
  Select uMsg 
    Case #WM_NOTIFY 
      *hdr.NMHDR = lParam 
      If *hdr\code= #HDN_BEGINTRACKW And *hdr\idFrom = HeaderID 
        Result = #True 
      EndIf  
    Default 
      Result = CallWindowProc_(_OldProc,wnd,uMsg,wParam,lParam) 
  EndSelect 
  ProcedureReturn Result 
EndProcedure

; eigene Procedure zur Auswahl des aktuellen ListIcon
; jeweils Windows-Handle und PB-Nummer fr die Aktualisierung
; des Inhalts in der Procedure KillFocus() und das Auslesen
; des Zelleninhalts fr den Editiervorgang
Procedure ActualListUse()
  Select _hwndlst
    Case lsticogd_0
      _ActList=#List_0
      ListGadget=lsticogd_0
      If IsGadget(#EditListStrg)
      EndIf
    Case lsticogd_1
      _ActList=#List_1
      ListGadget=lsticogd_1
      If IsGadget(#EditListStrg)
      EndIf
    Case lsticogd_2
      _ActList=#List_2
      ListGadget=lsticogd_2
      If IsGadget(#EditListStrg)
      EndIf
    Case lsticogd_3
      _ActList=#List_3
      ListGadget=lsticogd_3
      If IsGadget(#EditListStrg)
      EndIf
  EndSelect
EndProcedure

; Die folgenden Proceduren stammen aus dem PureArea.net
; Das File heit: ListIcon_Editable.pb

; English forum: Author: El Choni, Date: 09. May 2003

; fr das ListView editieren entnommene Proceduren von ElChoni
; die jedoch zum Teil von mir angepasst worden sind.

; Das Textgadget mit der Nummer 2 im Original-Code ist hier ge-
; andert auf #EditListStrg mit Nummerierung in der allgemeinen
; Gadget-Enumeration am Anfang des Programms. Das ListIcon wird
; jeweil aktualisiert zugewiesen

; Original von ElChoni
Procedure WndProc(hWnd, uMsg, wParam, lParam) 
  result = #PB_ProcessPureBasicEvents 
  Select uMsg 
    Case #WM_NOTIFY 
      *pnmh.NMHDR = lParam 
      Select *pnmh\code 
        Case #NM_CUSTOMDRAW 
          *LVCDHeader.NMLVCUSTOMDRAW = lParam 
          If *LVCDHeader\nmcd\hdr\hWndFrom=ListGadget 
            Select *LVCDHeader\nmcd\dwDrawStage 
              Case #CDDS_PREPAINT 
                result = #CDRF_NOTIFYITEMDRAW 
              Case #CDDS_ITEMPREPAINT 
                result = #CDRF_NOTIFYSUBITEMDRAW 
              Case #CDDS_SUBITEMPREPAINT 
                Row = *LVCDHeader\nmcd\dwItemSpec 
                Col = *LVCDHeader\iSubItem 
                result = #CDRF_NEWFONT 
            EndSelect 
          EndIf 
      EndSelect 
  EndSelect 
  ProcedureReturn result 
EndProcedure

; angepat
Procedure LViewProc(hWnd, uMsg, wParam, lParam) 
  result = 0 
  ; eingefgt Auswahl des angewhlten ListIconGadget (Windows-Handle)
  Select hwnd
    Case lsticogd_0
      _hwndlst=hwnd
    Case lsticogd_1
      _hwndlst=hwnd
    Case lsticogd_2
      _hwndlst=hwnd
    Case lsticogd_3
      _hwndlst=hwnd
  EndSelect
  ; etwas vereinfachter Originalteil der Procedure
  Select uMsg
    Case #WM_LBUTTONDBLCLK
      If hWnd<>hEdit
        KillFocus()
        pInfo.LVHITTESTINFO
        pInfo\pt\x = LoWord(lParam)
        pInfo\pt\y = HiWord(lParam)
        SendMessage_(hWnd, #LVM_SUBITEMHITTEST, 0, pInfo) 
        rc.RECT 
        rc\top = pInfo\iSubItem 
        rc\left = #LVIR_BOUNDS 
        SendMessage_(hWnd, #LVM_GETSUBITEMRECT, pInfo\iItem, rc) 
        If hEdit=0 
          UseGadgetList(hWnd) 
          CurItem = pInfo\iItem 
          CurSubItem = pInfo\iSubItem 
          Text$ = GetGadgetItemText(_ActList, CurItem, CurSubItem) 
          ; eingefgt sperren des Editierens fr bestimmte Zeilen oder Spalten
          If CurSubItem>0 Or _ActList=#List_1       ; Spalte 1 editieren immer sperren auer Nebenkosten
            If _ActList=#List_1 And CurItem=9       ; Summenzeile Nebenkosten sperren
            ElseIf _ActList=#List_2 And CurSubItem=1; Summespalte Spesen sperren
            ElseIf _ActList=#List_2 And CurItem=0   ; Summenzeile Brutto Spesen sperren
            ElseIf _ActList=#List_3 And CurItem=0   ; Summenfeld Auszahlung Reisekosten sperren
            ElseIf _ActList=#List_3 And CurItem=1   ; Summenfeld Auszahlung Nebenkosten sperren
            ElseIf _ActList=#List_3 And CurItem=3   ; Summenfeld Auszahlungsbetrag sperren
            Else
              If CurSubItem=0
                rc\right = rc\left+SendMessage_(hWnd, #LVM_GETCOLUMNWIDTH, 0, 0) 
              EndIf 
              hEdit = StringGadget(#EditListStrg, rc\left+1, rc\top, rc\right-rc\left-1, rc\bottom-rc\top-1, Text$, #PB_String_BorderLess) 
              SendMessage_(hEdit, #WM_SETFONT, FontReg, #True) 
              OldEditProc = SetWindowLong_(hEdit, #GWL_WNDPROC, @EditProc()) 
              SetFocus_(hEdit) 
            EndIf
          EndIf
        EndIf 
      Else 
        result = CallWindowProc_(OldLViewProc, hWnd, uMsg, wParam, lParam) 
      EndIf 
    Case #WM_LBUTTONDOWN 
      ActualListUse()
      If hWnd<>hEdit
        KillFocus()
        ; Hinzugefgt, Eintrag des letzten aktuellen Gadget
        _OldActList=_ActList
        ; original
        pInfo.LVHITTESTINFO
        pInfo\pt\x = LoWord(lParam)
        pInfo\pt\y = HiWord(lParam)
        SendMessage_(hWnd, #LVM_SUBITEMHITTEST, 0, pInfo)
        rc.RECT
        rc\top = pInfo\iSubItem
        rc\left = #LVIR_BOUNDS
        SendMessage_(hWnd, #LVM_GETSUBITEMRECT, pInfo\iItem, rc)
        rc\left+1
        rc\bottom-1
        ; gendert damit der Rahmen beim Wechsel der Liste gelscht wird
        If CellSelectOn And hwnd=_OldListHwnd
          InvalidateRect_(hWnd, rct, #True)
        Else
          If _OldListHwnd
            InvalidateRect_(_OldListHwnd, rct, #True)
          EndIf
        EndIf
       ; letzte Auswahl speichern
        _OldListHwnd=ListGadget
        ; original
        CellSelectOn = 1
        CurSelItem = pInfo\iItem
        CurSelSubItem = pInfo\iSubItem
        If CurSelSubItem=0
          rc\right = rc\left+SendMessage_(hWnd, #LVM_GETCOLUMNWIDTH, 0, 0)
        EndIf
        DrawRectangle(hWnd, rc) 
        CopyMemory(rc, rct, SizeOf(RECT)) 
      Else 
        SetFocus_(hEdit) 
        result = CallWindowProc_(OldLViewProc, hWnd, uMsg, wParam, lParam) 
      EndIf 
    Case #WM_CTLCOLOREDIT 
      If GetFocus_()=lParam 
        SetBkMode_(wParam, #TRANSPARENT) 
        TextBkColOr = RGB(208, 208, 176) 
        TextColor = RGB(0, 0, 0) 
        SetTextColor_(wParam, TextColor) 
        result = CreateSolidBrush_(TextBkColor) 
      Else 
        result = CallWindowProc_(OldLViewProc, hWnd, uMsg, wParam, lParam) 
      EndIf 
    Case #WM_VSCROLL 
      result = CallWindowProc_(OldLViewProc, hWnd, uMsg, wParam, lParam) 
      rc.RECT 
      TopVisibleItem = SendMessage_(hWnd, #LVM_GETTOPINDEX, 0, 0) 
      If CellSelectOn 
        rc\top = CurSelSubItem 
        rc\left = #LVIR_BOUNDS 
        SendMessage_(hWnd, #LVM_GETSUBITEMRECT, CurSelItem, rc) 
        rct\top = rc\top 
        rct\bottom = rc\bottom-1 
        If TopVisibleItem<=CurSelItem 
          DrawRectangle(hWnd, rct) 
        EndIf 
      EndIf 
      If hEdit 
        If TopVisibleItem<=CurItem 
          ResizeGadget(#EditListStrg, -1, rc\top, -1, -1) 
          HideGadget(#EditListStrg, #False) 
          RedrawWindow_(hEdit, 0, 0, #RDW_INTERNALPAINT|#RDW_ERASE|#RDW_INVALIDATE) 
        Else 
          HideGadget(#EditListStrg, #True) 
        EndIf 
        SetFocus_(hEdit) 
      EndIf 
    Case #WM_HSCROLL 
      result = CallWindowProc_(OldLViewProc, hWnd, uMsg, wParam, lParam) 
      rc.RECT 
      TopVisibleItem = SendMessage_(hWnd, #LVM_GETTOPINDEX, 0, 0) 
      If CellSelectOn 
        rc\top = CurSelSubItem 
        rc\left = #LVIR_BOUNDS 
        SendMessage_(hWnd, #LVM_GETSUBITEMRECT, CurSelItem, rc) 
        rct\left = rc\left+1 
        rct\right = rc\right 
        If TopVisibleItem<=CurSelItem 
          DrawRectangle(hWnd, rct) 
        EndIf 
      EndIf 
      If hEdit 
        If TopVisibleItem<=CurItem 
          ResizeGadget(#EditListStrg, rc\left, -1, -1, -1) 
          HideGadget  (#EditListStrg, #False) 
          RedrawWindow_(hEdit, 0, 0, #RDW_INTERNALPAINT|#RDW_ERASE|#RDW_INVALIDATE) 
        Else 
          HideGadget(#EditListStrg, #True) 
        EndIf 
        SetFocus_(hEdit) 
      EndIf 
    Default 
      result = CallWindowProc_(OldLViewProc, hWnd, uMsg, wParam, lParam) 
  EndSelect 
  ProcedureReturn result 
EndProcedure
; Original von ElChoni
Procedure EditProc(hWnd, uMsg, wParam, lParam) 
  result = 0
  Select uMsg
    Case #WM_KEYDOWN
      result = CallWindowProc_(OldEditProc, hWnd, uMsg, wParam, lParam)
      If wParam=#VK_RETURN
        KillFocus()
      EndIf
    Default
      result = CallWindowProc_(OldEditProc, hWnd, uMsg, wParam, lParam)
  EndSelect
  ProcedureReturn result
EndProcedure
; Original von ElChoni
Procedure DrawRectangle(hWnd, *rc.RECT)
  hDC = GetDC_(hWnd)
  OldPen = SelectObject_(hDC, GetStockObject_(#BLACK_PEN))
  OldBrush = SelectObject_(hDC, GetStockObject_(#NULL_BRUSH))
  Rectangle_(hDC, *rc\left, *rc\top, *rc\right, *rc\bottom)
  SelectObject_(hDC, OldBrush)
  SelectObject_(hDC, OldPen)
  ReleaseDC_(hWnd, hDC)
EndProcedure

; ein wenig erweiterte Procedure um Ergebniss in Zahl zu wandeln und die
; Summemzeilen zu fllen
Procedure KillFocus() 
  If hEdit
    ; hinzugefgt Texteintrge formatieren
    txn$=GetGadgetText(#EditListStrg)
    If CurSubItem<>4 ; nur in Spalte 5 immer Text zulassen
      If _ActList=#List_1 And CurSubItem=0    ; Ausnahme Spalte 1 Nebenkosten
      ElseIf _ActList=#List_0 And CurSubItem=1; Ausnahme Spalte 2 Datum
        txn$=Left(txn$,10); Datum auf 10 Zeichen krzen
      ElseIf _ActList=#List_0 And CurSubItem=2; Ausnahme Spalte 3 Antritt
        txn$=Left(txn$,10); Zeit auf 5 Zeichen krzen
      ElseIf _ActList=#List_0 And CurSubItem=3; Ausnahme Spalte 3 Ende
        txn$=Left(txn$,10); Zeit auf 5 Zeichen krzen
      ElseIf _ActList=#List_0 And CurSubItem=5; Ausnahme Spalte 5 Land
        txn$=UCase(Left(txn$,5)); Land auf 5 Zeichen krzen und in Grobuchstaben wandeln
      Else; 2 stellige Fliekommazahl, wenn 0.00, dann Leerstring
        txn$=ReplaceString(txn$,",",".",1,1)
        txn$=StrF(ValF(txn$),2)
        If txn$="0.00": txn$="": EndIf
      EndIf
    EndIf
    ; bertragen der Information in das ListIconGadget, dabei Prfung ob die
    ; Liste gewechselt wurde
    If _OldActList=_ActList ; kein Wechsel der Liste
      SetGadgetItemText(_ActList, CurItem, txn$, CurSubItem)
    Else
      SetGadgetItemText(_OldActList, CurItem, txn$, CurSubItem)
    EndIf
    ; Editierstringgadget lschen
    FreeGadget(#EditListStrg)
    hEdit = 0
    ; hinzugefgt Summenzeilen und Spalten ndern
    Dim bfl.f(20)
    ; Nebenkosten
    If _ActList=#List_1
     For a = 0 To 8
      For b=1 To 3
       bfl(b)+ValF(GetGadgetItemText(#List_1,a,b))
      Next b
     Next a
     For a= 1 To 3
      SetGadgetItemText(#List_1,9,StrF(bfl(a),2),a)
     Next a
    EndIf
    ; Reisekostenliste Einzelpositionsspalten
    Dim bfl.f(20)
    If _ActList=#List_0
      For a = 0 To 9
        For b=6 To 13
          bfl(b)+ValF(GetGadgetItemText(#List_0,a,b))
        Next b
      Next a
      For a=2 To 9
        SetGadgetItemText(#List_2,0,StrF(bfl(a+4),2),a)
      Next a
    EndIf
    ; Reisekostenliste Summenspalte
    Dim bfl.f(20)
    If _ActList=#List_0 Or _ActList=#List_2
      For a = 2 To 9
        For b=0 To 2
          bfl(b)+ValF(GetGadgetItemText(#List_2,b,a))
        Next b
      Next a
      For a=0 To 2
        SetGadgetItemText(#List_2,a,StrF(bfl(a),2),1)
      Next a
    EndIf
    ; Auszahlungsliste immer aktualisieren
    SetGadgetItemText(#List_3,0,GetGadgetItemText(#List_2,0,1),1)
    SetGadgetItemText(#List_3,1,GetGadgetItemText(#List_1,9,1),1)
    txn$=StrF(ValF(GetGadgetItemText(#List_3,0,1))+ValF(GetGadgetItemText(#List_3,1,1))-ValF(GetGadgetItemText(#List_3,2,1)),2)
    SetGadgetItemText(#List_3,3,txn$,1)
  EndIf 
EndProcedure
; IDE Options = PureBasic v3.94 (Windows - x86)
; CursorPosition = 106
; FirstLine = 106
; Folding = --